"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageHeaderContent = exports.ALIGN_ITEMS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../../icon");
var _tabs = require("../../tabs");
var _flex = require("../../flex");
var _spacer = require("../../spacer");
var _title = require("../../title");
var _text = require("../../text");
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _breadcrumbs = require("../../breadcrumbs");
var _global_styling = require("../../../global_styling");
var _restrict_width = require("../_restrict_width");
var _page_header = require("./page_header.styles");
var _page_header_content = require("./page_header_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "description", "breadcrumbs", "breadcrumbProps", "alignItems", "responsive", "rightSideItems", "rightSideGroupProps", "children", "restrictWidth", "paddingSize", "bottomBorder", "style"],
  _excluded2 = ["label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var ALIGN_ITEMS = exports.ALIGN_ITEMS = ['top', 'bottom', 'center', 'stretch'];

// Gets all the tab props including the button or link props

/**
 * The left side can either be a title with optional description and/or icon;
 * Or a list of tabs,
 * Or a custom node
 */

var EuiPageHeaderContent = exports.EuiPageHeaderContent = function EuiPageHeaderContent(_ref) {
  var className = _ref.className,
    pageTitle = _ref.pageTitle,
    pageTitleProps = _ref.pageTitleProps,
    iconType = _ref.iconType,
    iconProps = _ref.iconProps,
    tabs = _ref.tabs,
    tabsProps = _ref.tabsProps,
    description = _ref.description,
    breadcrumbs = _ref.breadcrumbs,
    breadcrumbProps = _ref.breadcrumbProps,
    alignItems = _ref.alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    rightSideItems = _ref.rightSideItems,
    rightSideGroupProps = _ref.rightSideGroupProps,
    children = _ref.children,
    restrictWidth = _ref.restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    _paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _bottom_border = _ref.bottomBorder,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsiveBreakpoint = (0, _services.useIsWithinBreakpoints)(['xs', 's'], !!responsive);
  var classes = (0, _classnames.default)('euiPageHeaderContent', className);
  var pageHeaderStyles = (0, _services.useEuiMemoizedStyles)(_page_header.euiPageHeaderStyles);
  var contentStyles = (0, _services.useEuiMemoizedStyles)(_page_header_content.euiPageHeaderContentStyles);
  var styles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, style);
  var paddingSides = 'vertical';
  var paddingSize = _paddingSize;
  var bottomBorder = _bottom_border;
  var onlyChildren = !tabs && !pageTitle && !rightSideItems && !description && children;
  var onlyTabs = tabs && !pageTitle && !rightSideItems && !description && !children;
  var tabsAsTitle = tabs && !pageTitle;
  var tabsAtTheBottom = pageTitle && tabs;
  var borderWithoutPadding = (!paddingSize || paddingSize === 'none') && bottomBorder;
  if (onlyTabs) {
    paddingSize = 'none';
  } else if (tabsAsTitle) {
    paddingSides = 'bottom';
  } else if (tabsAtTheBottom) {
    paddingSides = 'top';
    bottomBorder = bottomBorder === false ? false : true;
  } else if (borderWithoutPadding) {
    paddingSides = 'bottom';
    paddingSize = 'l';
  }
  var blockPadding = (0, _global_styling.useEuiPaddingCSS)(paddingSides);
  var cssStyles = [contentStyles.euiPageHeaderContent, bottomBorder && pageHeaderStyles.border, blockPadding[paddingSize]];
  var childrenOnlyStyles = [contentStyles.childrenOnly.flex, contentStyles[alignItems || 'center'], isResponsiveBreakpoint && responsive && (responsive === 'reverse' ? contentStyles.childrenOnly.responsiveReverse : contentStyles.childrenOnly.responsive)];

  // Don't go any further if there's no other content than children
  if (onlyChildren) {
    return (0, _react2.jsx)("div", _extends({
      css: cssStyles
    }, rest), (0, _react2.jsx)("div", {
      css: childrenOnlyStyles
    }, children));
  }
  var descriptionNode;
  if (description) {
    descriptionNode = (0, _react2.jsx)(_react.default.Fragment, null, (pageTitle || tabs) && (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, {
      grow: false
    }, (0, _react2.jsx)("p", null, description)));
  }
  var optionalBreadcrumbs = breadcrumbs ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_breadcrumbs.EuiBreadcrumbs, _extends({
    breadcrumbs: breadcrumbs
  }, breadcrumbProps)), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  })) : undefined;
  var pageTitleNode;
  if (pageTitle) {
    var iconCssStyles = [contentStyles.euiPageHeaderContent__titleIcon, iconProps === null || iconProps === void 0 ? void 0 : iconProps.css];
    var icon = iconType ? (0, _react2.jsx)(_icon.EuiIcon, _extends({
      size: "xl"
    }, iconProps, {
      css: iconCssStyles,
      type: iconType
    })) : undefined;
    pageTitleNode = (0, _react2.jsx)(_title.EuiTitle, _extends({}, pageTitleProps, {
      size: "l"
    }), (0, _react2.jsx)("h1", null, icon, pageTitle));
  }
  var tabsNode;
  if (tabs) {
    var _tabs$find;
    var tabsSize = pageTitle ? 'l' : 'xl';
    var renderTabs = function renderTabs() {
      return tabs.map(function (tab, index) {
        var label = tab.label,
          tabRest = _objectWithoutProperties(tab, _excluded2);
        return (0, _react2.jsx)(_tabs.EuiTab, _extends({
          key: index
        }, tabRest), label);
      });
    };

    // When tabs exist without a pageTitle, we need to recreate an h1 based on the currently selected tab and visually hide it
    var screenReaderPageTitle = !pageTitle && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("h1", null, (_tabs$find = tabs.find(function (obj) {
      return obj.isSelected === true;
    })) === null || _tabs$find === void 0 ? void 0 : _tabs$find.label));
    tabsNode = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode && (0, _react2.jsx)(_spacer.EuiSpacer, null), screenReaderPageTitle, (0, _react2.jsx)(_tabs.EuiTabs, _extends({}, tabsProps, {
      bottomBorder: false,
      size: tabsSize
    }), renderTabs()));
  }
  var childrenNode = children && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), children);
  var bottomContentNode;
  if (tabsNode && pageTitleNode) {
    bottomContentNode = (0, _react2.jsx)("div", {
      className: "euiPageHeaderContent__bottom"
    }, pageTitleNode && tabsNode);
  }

  /**
   * The left side order depends on if a `pageTitle` was supplied.
   * If not, but there are `tabs`, then the tabs become the page title
   */
  var leftSideOrder;
  if (tabsNode && !pageTitleNode) {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, tabsNode, descriptionNode, childrenNode);
  } else {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode, descriptionNode, childrenNode);
  }
  var leftSideFlexItem = (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: 2,
    css: contentStyles.euiPageHeaderContent__leftSideItems
  }, leftSideOrder);
  var rightSideFlexItem;
  if (rightSideItems && rightSideItems.length) {
    var itemsToRender = isResponsiveBreakpoint ? rightSideItems : _toConsumableArray(rightSideItems).reverse();
    var rightSideFlexItems = itemsToRender.map(function (item, index) {
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        key: index,
        grow: false,
        css: contentStyles.euiPageHeaderContent__rightSideItem
      }, item);
    });
    var _cssStyles = [contentStyles.euiPageHeaderContent__rightSideItems, rightSideGroupProps === null || rightSideGroupProps === void 0 ? void 0 : rightSideGroupProps.css];
    rightSideFlexItem = (0, _react2.jsx)(_flex.EuiFlexGroup, _extends({
      gutterSize: "l",
      responsive: false,
      wrap: true
    }, rightSideGroupProps, {
      css: _cssStyles
    }), rightSideFlexItems);
  }
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles,
    style: styles
  }, rest), optionalBreadcrumbs, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: !!responsive,
    css: contentStyles.euiPageHeaderContent__top,
    className: "euiPageHeaderContent__top",
    alignItems: alignItems === 'bottom' ? 'flexEnd' : alignItems === 'top' ? 'flexStart' : alignItems,
    gutterSize: "l",
    wrap: true
  }, isResponsiveBreakpoint && responsive === 'reverse' ? (0, _react2.jsx)(_react.default.Fragment, null, rightSideFlexItem, leftSideFlexItem) : (0, _react2.jsx)(_react.default.Fragment, null, leftSideFlexItem, rightSideFlexItem)), bottomContentNode);
};
EuiPageHeaderContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * If not set, defaults to true if `tabs` are passed and render at the bottom of the page.
     * Otherwise, defaults to false.
     */
  bottomBorder: _propTypes.default.bool,
  /**
     * Adjust the padding.
     * When using this setting it's best to be consistent throughout all similar usages
     */
  paddingSize: _propTypes.default.any,
  /**
     * Set to false if you don't want the children to stack at small screen sizes.
     * Set to `reverse` to display the right side content first for the sake of hierarchy (like global time)
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["reverse"])]),
  /**
     * Vertical alignment of the left and right side content;
     * Default is `center` for custom content, but `top` for when `pageTitle` or `tabs` are included
     */
  alignItems: _propTypes.default.any,
  /**
     * Pass custom an array of content to this side usually up to 3 buttons.
     * The first button should be primary, usually with `fill`. At larger breakpoints, items will
     * render from right to left, but will collapse vertically and render left to right on smaller mobile screens.
     */
  rightSideItems: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),
  /**
     * Additional EuiFlexGroup props to pass to the container of the `rightSideItems`
     */
  rightSideGroupProps: _propTypes.default.any,
  /**
     * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
     */
  children: _propTypes.default.node,
  /**
     * Position is dependent on existing with a `pageTitle` or `tabs`
     * Automatically get wrapped in a single paragraph tag inside an EuiText block
     */
  description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),
  /**
     * Wrapped in an `H1` so choose appropriately.
     * A simple string is best
     */
  pageTitle: _propTypes.default.node,
  /**
     * Additional props to pass to the EuiTitle
     */
  pageTitleProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    textTransform: _propTypes.default.any,
    id: _propTypes.default.string
  }),
  /**
     * Optional icon to place to the left of the title
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
  /**
     * Additional EuiIcon props to apply to the optional icon
     */
  iconProps: _propTypes.default.any,
  /**
     * Optional array breadcrumbs that render before the `pageTitle`
     */
  breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    onClick: _propTypes.default.func,
    /**
         * Visible label of the breadcrumb
         */
    text: _propTypes.default.node.isRequired,
    /**
         * Force a max-width on the breadcrumb text
         */
    truncate: _propTypes.default.bool,
    /**
         * @deprecated - if a custom color is wanted, use the `css` prop to pass custom css
         */
    color: _propTypes.default.any,
    /**
         * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
         */
    "aria-current": _propTypes.default.any,
    /**
         * Creates a breadcrumb that toggles a popover dialog. Takes any rendered node(s),
         * or a render function that will pass callback allowing you to close the
         * breadcrumb popover from within your popover content.
         *
         * If passed, both `href` and `onClick` will be ignored - the breadcrumb's
         * click behavior should only trigger a popover.
         */
    popoverContent: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]),
    /**
         * Allows customizing the popover if necessary. Accepts any props that
         * [EuiPopover](/#/layout/popover) accepts, except for props that control state.
         */
    popoverProps: _propTypes.default.any
  }).isRequired),
  /**
     * Adjust the props of [EuiBreadcrumbs](#/navigation/breadcrumbs)
     */
  breadcrumbProps: _propTypes.default.any,
  /**
     * In-app navigation presented as large borderless tabs.
     * Accepts an array of `EuiTab` objects;
     */
  tabs: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Visible text of the tab
       */
    label: _propTypes.default.node.isRequired
  }).isRequired),
  /**
     * Any extras to apply to the outer tabs container.
     * Extends `EuiTabs`
     */
  tabsProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node,
    /**
         * Adds a bottom border to separate it from the content after
         */
    bottomBorder: _propTypes.default.bool
  }),
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};