"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiInlineEditReadModeStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiInlineEditReadModeStyles = exports.euiInlineEditReadModeStyles = function euiInlineEditReadModeStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiInlineEditReadMode: /*#__PURE__*/(0, _react.css)(";label:euiInlineEditReadMode;"),
    // Override the cursor and allow users to highlight text when in the read only state
    isReadOnly: /*#__PURE__*/(0, _react.css)("&:disabled{cursor:text;color:", euiTheme.colors.text, ";user-select:text;};label:isReadOnly;"),
    hasPlaceholder: /*#__PURE__*/(0, _react.css)(".euiText,.euiTitle{color:", euiTheme.components.forms.colorHasPlaceholder, ";};label:hasPlaceholder;")
  };
};