"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSuperSelectStyles = exports.euiSuperSelectItemStyles = exports.euiSuperSelectControlStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiSuperSelectStyles = exports.euiSuperSelectStyles = {
  euiSuperSelect__listbox: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', '300px'), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'auto'), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-x', 'hidden'), ";;label:euiSuperSelect__listbox;")
};
var euiSuperSelectItemStyles = exports.euiSuperSelectItemStyles = function euiSuperSelectItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSuperSelect__item: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:euiSuperSelect__item;"),
    hasDividers: /*#__PURE__*/(0, _react.css)("&:not(:last-of-type){", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";};label:hasDividers;")
  };
};
var euiSuperSelectControlStyles = exports.euiSuperSelectControlStyles = function euiSuperSelectControlStyles(euiThemeContext) {
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  var formVariables = (0, _form.euiFormVariables)(euiThemeContext);
  return {
    euiSuperSelect__control: /*#__PURE__*/(0, _react.css)(formStyles.shared, " display:block;", (0, _global_styling.logicalTextAlignCSS)('left'), " ", (0, _global_styling.euiTextTruncate)('' // maxWidth is already set by width modifiers below
    ), " &:focus{", formStyles.focus, ";};label:euiSuperSelect__control;"),
    // Since the control is a button and not an actual input, we have to set
    // certain state styles manually instead of relying on CSS selectors
    open: /*#__PURE__*/(0, _react.css)(formStyles.focus, ";;label:open;"),
    invalid: /*#__PURE__*/(0, _react.css)(formStyles.invalid, ";;label:invalid;"),
    disabled: /*#__PURE__*/(0, _react.css)(formStyles.disabled, ";;label:disabled;"),
    readOnly: /*#__PURE__*/(0, _react.css)(formStyles.readOnly, ";;label:readOnly;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: "\n      ".concat(formStyles.uncompressed, "\n      /* Match line height with inputs */\n      ").concat((0, _global_styling.logicalCSS)('padding-vertical', 0), "\n      line-height: ").concat(formVariables.controlHeight, ";\n    "),
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, (0, _global_styling.logicalCSS)('padding-vertical', 0), " line-height:", formVariables.controlCompressedHeight, ";;label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/(0, _react.css)(formStyles.inGroup, ";label:inGroup;"),
    // Children
    euiSuperSelect__placeholder: /*#__PURE__*/(0, _react.css)("color:", formVariables.controlPlaceholderText, ";;label:euiSuperSelect__placeholder;")
  };
};