"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorPickerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiColorPickerStyles = exports.euiColorPickerStyles = function euiColorPickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // 5 columns of swatches + margins + border
  var colorPickerWidth = (0, _global_styling.mathWithUnits)([euiTheme.size.l, euiTheme.size.s], function (x, y) {
    return x * 5 + y * 4;
  });
  return {
    euiColorPicker: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('width', colorPickerWidth), "display:flex;flex-direction:column;gap:", euiTheme.size.s, ";;label:euiColorPicker;"),
    euiColorPicker__swatches: /*#__PURE__*/(0, _react.css)("display:flex;flex-wrap:wrap;gap:", euiTheme.size.s, ";;label:euiColorPicker__swatches;"),
    euiColorPicker__alphaRange: /*#__PURE__*/(0, _react.css)(".euiRangeInput{", (0, _global_styling.logicalCSS)('min-width', 0), ";};label:euiColorPicker__alphaRange;"),
    // Adds a stroke color for the swatchInput icon. Unlike most EuiIcons it has a stroke in the SVG
    // Targets a custom className applied directly to the <svg> icon
    euiColorPicker__swatchInputIcon: /*#__PURE__*/(0, _react.css)(".euiSwatchInput__stroke{fill:none;stroke:", euiTheme.colors.borderBaseFormsColorSwatch, ";};label:euiColorPicker__swatchInputIcon;")
  };
};