"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBreadcrumbPopoverStyles = exports.euiBreadcrumbContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _button = require("../../global_styling/mixins/_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Styles cast to inner <a>, <button>, <span> elements
 */
var euiBreadcrumbContentStyles = exports.euiBreadcrumbContentStyles = function euiBreadcrumbContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Reuse button colors for `type="application`" clickable breadcrumbs
  var applicationButtonColors = (0, _button.euiButtonColor)(euiThemeContext, 'primary');

  // Create custom darker gray colors for non-clickable application breadcrumbs
  // The numbers/ratios are fairly specific here to pass WCAG AA contrast minimums
  var applicationTextColors = {
    backgroundColor: euiTheme.components.breadcrumbsApplicationBackground,
    color: euiTheme.components.breadcrumbsApplicationColor
  };
  return {
    euiBreadcrumb__content: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.regular, ";text-align:center;vertical-align:baseline;&:not(.euiLink){color:", euiTheme.colors.textSubdued, ";};label:euiBreadcrumb__content;"),
    // Truncation styles
    isTruncated: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 10;
    })), ";;label:isTruncated;"),
    isTruncatedLast: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)('none'), ";;label:isTruncatedLast;"),
    isInteractive: /*#__PURE__*/(0, _react.css)("&:not(:disabled){text-decoration:underline;&[class*='euiLink-subdued']{&:hover,&:focus{color:", euiTheme.colors.text, ";}}};label:isInteractive;"),
    // Types
    page: /*#__PURE__*/(0, _react.css)("&:is(a):focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'inset'), ";}&:is(button):focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'center'), ";};label:page;"),
    application: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.medium, ";background-color:", applicationTextColors.backgroundColor, ";clip-path:polygon(\n        0 0,\n        calc(100% - ", euiTheme.size.s, ") 0,\n        100% 50%,\n        calc(100% - ", euiTheme.size.s, ") 100%,\n        0 100%,\n        ", euiTheme.size.s, " 50%\n      );color:", applicationTextColors.color, ";line-height:", euiTheme.size.base, ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), " &:is(a),&:is(button){background-color:", applicationButtonColors.backgroundColor, ";color:", applicationButtonColors.color, ";:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'inset'), " :focus-visible{border-radius:", euiTheme.border.radius.medium, ";clip-path:none;}}};label:application;"),
    applicationStyles: {
      onlyChild: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";clip-path:none;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), ";;label:onlyChild;"),
      firstChild: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalBorderRadiusCSS)("".concat(euiTheme.border.radius.medium, " 0 0 ").concat(euiTheme.border.radius.medium), true), " clip-path:polygon(\n          0 0,\n          calc(100% - ", euiTheme.size.s, ") 0,\n          100% 50%,\n          calc(100% - ", euiTheme.size.s, ") 100%,\n          0 100%\n        );", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.m), ";;label:firstChild;"),
      lastChild: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalBorderRadiusCSS)("0 ".concat(euiTheme.border.radius.medium, " ").concat(euiTheme.border.radius.medium, " 0"), true), " clip-path:polygon(\n          0 0,\n          100% 0,\n          100% 100%,\n          0 100%,\n          ", euiTheme.size.s, " 50%\n        );", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.m), ";;label:lastChild;")
    }
  };
};
var euiBreadcrumbPopoverStyles = exports.euiBreadcrumbPopoverStyles = function euiBreadcrumbPopoverStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiBreadcrumb__popoverButton: /*#__PURE__*/(0, _react.css)("max-inline-size:100%;display:inline-flex;align-items:center;gap:", euiTheme.size.xs, ";;label:euiBreadcrumb__popoverButton;"),
    euiBreadcrumb__popoverTruncation: /*#__PURE__*/(0, _react.css)(";label:euiBreadcrumb__popoverTruncation;"),
    popoverWrapper: {
      euiBreadcrumb__popoverWrapper: /*#__PURE__*/(0, _react.css)(";label:euiBreadcrumb__popoverWrapper;"),
      page: /*#__PURE__*/(0, _react.css)("max-inline-size:calc(\n          100% - ", (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x + 1;
      }), "\n        );;label:page;"),
      application: null
    }
  };
};