"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCantAnimate = exports.euiCanAnimate = exports.EuiThemeAnimationSpeeds = exports.EuiThemeAnimationEasings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A constant storing the `prefers-reduced-motion` media query
 * so that when it is turned off, animations are not run.
 */
var euiCanAnimate = exports.euiCanAnimate = '@media screen and (prefers-reduced-motion: no-preference)';

/**
 * A constant storing the `prefers-reduced-motion` media query that will
 * only apply the content if the setting is off (reduce).
 */
var euiCantAnimate = exports.euiCantAnimate = '@media screen and (prefers-reduced-motion: reduce)';

/**
 * Speeds / Durations / Delays
 */

var EuiThemeAnimationSpeeds = exports.EuiThemeAnimationSpeeds = ['extraFast', 'fast', 'normal', 'slow', 'extraSlow'];
/**
 * Easings / Timing functions
 */

var EuiThemeAnimationEasings = exports.EuiThemeAnimationEasings = ['bounce', 'resistance'];
//# sourceMappingURL=animations.js.map