"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLineSeriesStyles = getLineSeriesStyles;
exports.getAreaSeriesStyles = getAreaSeriesStyles;
const common_1 = require("../../../utils/common");
function getLineSeriesStyles(baseStyle, seriesStyle) {
    var _a, _b;
    if (!seriesStyle)
        return baseStyle;
    const isolatedPointStyleOverrides = (0, common_1.mergePartial)(baseStyle.isolatedPoint, seriesStyle.isolatedPoint, undefined, seriesStyle.point ? [seriesStyle.point] : []);
    return (0, common_1.mergePartial)(baseStyle, {
        isolatedPoint: {
            ...isolatedPointStyleOverrides,
            visible: (_b = (_a = seriesStyle === null || seriesStyle === void 0 ? void 0 : seriesStyle.isolatedPoint) === null || _a === void 0 ? void 0 : _a.visible) !== null && _b !== void 0 ? _b : baseStyle.isolatedPoint.visible,
        },
    }, undefined, [seriesStyle]);
}
function getAreaSeriesStyles(baseStyle, seriesStyle) {
    var _a, _b;
    if (!seriesStyle)
        return baseStyle;
    const isolatedPointStyleOverrides = (0, common_1.mergePartial)(baseStyle.isolatedPoint, seriesStyle.isolatedPoint, undefined, seriesStyle.point ? [seriesStyle.point] : []);
    return (0, common_1.mergePartial)(baseStyle, {
        isolatedPoint: {
            ...isolatedPointStyleOverrides,
            visible: (_b = (_a = seriesStyle === null || seriesStyle === void 0 ? void 0 : seriesStyle.isolatedPoint) === null || _a === void 0 ? void 0 : _a.visible) !== null && _b !== void 0 ? _b : baseStyle.isolatedPoint.visible,
        },
    }, undefined, [seriesStyle]);
}
//# sourceMappingURL=line_area_style.js.map