"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricText = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const text_measurements_1 = require("./text_measurements");
const common_1 = require("../../../../utils/common");
const specs_1 = require("../../specs");
function lineClamp(maxLines) {
    return {
        textOverflow: 'ellipsis',
        display: '-webkit-box',
        WebkitLineClamp: maxLines,
        lineClamp: maxLines,
        WebkitBoxOrient: 'vertical',
        overflow: 'hidden',
        whiteSpace: 'pre-wrap',
    };
}
const MetricText = ({ id, datum, style, onElementClick, highContrastTextColor, progressBarSize, textDimensions }) => {
    var _a, _b;
    const { heightBasedSizes: sizes, hasProgressBar, progressBarDirection, visibility, textParts } = textDimensions;
    const { extra, body } = datum;
    const containerClassName = (0, classnames_1.default)('echMetricText', {
        [`echMetricText--${progressBarSize}`]: hasProgressBar,
        'echMetricText--vertical': progressBarDirection === common_1.LayoutDirection.Vertical,
        'echMetricText--horizontal': progressBarDirection === common_1.LayoutDirection.Horizontal,
    });
    const TitleElement = () => (react_1.default.createElement("span", { style: {
            fontSize: sizes.titleFontSize,
            textAlign: style.titlesTextAlign,
            ...lineClamp(visibility.titleLines.length),
        }, title: datum.title }, datum.title));
    return (react_1.default.createElement("div", { className: containerClassName, style: { color: highContrastTextColor } },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__titlesBlock', `echMetricText__titlesBlock--${style.titlesTextAlign}`), style: datum.icon && {
                marginLeft: 'center' === style.titlesTextAlign || style.iconAlign === 'left' ? sizes.iconSize + text_measurements_1.PADDING : 0,
                marginRight: 'center' === style.titlesTextAlign || style.iconAlign === 'right' ? sizes.iconSize + text_measurements_1.PADDING : 0,
            } },
            visibility.title && (react_1.default.createElement("h2", { id: id, className: "echMetricText__title" }, onElementClick ? (react_1.default.createElement("button", { style: { outline: 'none' }, onMouseDown: (e) => e.stopPropagation(), onMouseUp: (e) => e.stopPropagation(), onClick: (e) => {
                    e.stopPropagation();
                    onElementClick();
                } },
                react_1.default.createElement(TitleElement, null))) : (react_1.default.createElement(TitleElement, null)))),
            visibility.subtitle && (react_1.default.createElement("p", { className: "echMetricText__subtitle", style: {
                    fontSize: sizes.subtitleFontSize,
                    ...lineClamp(visibility.subtitleLines.length),
                }, title: datum.subtitle }, datum.subtitle))),
        datum.icon && (react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__icon', `echMetricText__icon--${style.iconAlign}`) }, (0, common_1.renderWithProps)(datum.icon, {
            width: sizes.iconSize,
            height: sizes.iconSize,
            color: highContrastTextColor,
        }))),
        react_1.default.createElement("div", { className: "echMetricText__gap" }, body && react_1.default.createElement("div", { className: "echMetricText__body" }, body)),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__valuesBlock', `echMetricText__valuesBlock--${style.valuesTextAlign}`) },
            react_1.default.createElement("div", null, visibility.extra && (react_1.default.createElement("p", { className: "echMetricText__extra", style: { fontSize: sizes.extraFontSize } }, extra))),
            react_1.default.createElement("div", { className: "echMetricText__valueGroup" },
                react_1.default.createElement("p", { className: "echMetricText__value", style: {
                        fontSize: sizes.valueFontSize,
                        textOverflow: (0, specs_1.isMetricWNumber)(datum) ? undefined : 'ellipsis',
                        color: datum.valueColor,
                    }, title: textParts.map(({ text }) => text).join('') }, textParts.map(({ emphasis, text }, i) => {
                    return emphasis === 'small' ? (react_1.default.createElement("span", { key: `${text}${i}`, className: "echMetricText__part", style: {
                            fontSize: sizes.valuePartFontSize,
                        } }, text)) : (text);
                })),
                datum.valueIcon && (react_1.default.createElement("p", { className: "echMetricText__valueIcon", style: {
                        fontSize: sizes.valueFontSize,
                        color: (_a = datum.valueColor) !== null && _a !== void 0 ? _a : highContrastTextColor,
                        marginRight: style.valuesTextAlign === 'center' ? -(sizes.valuePartFontSize + text_measurements_1.PADDING) : undefined,
                    } }, (0, common_1.renderWithProps)(datum.valueIcon, {
                    width: sizes.valuePartFontSize,
                    height: sizes.valuePartFontSize,
                    color: (_b = datum.valueColor) !== null && _b !== void 0 ? _b : highContrastTextColor,
                    verticalAlign: 'middle',
                })))))));
};
exports.MetricText = MetricText;
//# sourceMappingURL=text.js.map