"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GRAPH_PADDING = exports.HEADER_PADDING = exports.TICK_FONT_SIZE = exports.TICK_FONT = exports.getMaxTargetValueAssent = exports.TARGET_FONT_SIZE = exports.TARGET_FONT = exports.VALUE_FONT_SIZE = exports.VALUE_FONT = exports.SUBTITLE_FONT_ASCENT = exports.SUBTITLE_FONT_SIZE = exports.SUBTITLE_FONT = exports.TITLE_LINE_SPACING = exports.TITLE_FONT_ASCENT = exports.TITLE_FONT_SIZE = exports.FONT_PADDING = exports.TEXT_ASCENT_RATIO = exports.TITLE_FONT = exports.DARK_THEME_BULLET_STYLE = exports.LIGHT_THEME_BULLET_STYLE = void 0;
exports.getTextAscentHeight = getTextAscentHeight;
const default_theme_attributes_1 = require("../../common/default_theme_attributes");
const base_colors_1 = require("../../utils/themes/base_colors");
exports.LIGHT_THEME_BULLET_STYLE = {
    textColor: base_colors_1.LIGHT_BASE_COLORS.darkestShade,
    border: '#EDF0F5',
    barBackground: base_colors_1.LIGHT_BASE_COLORS.darkestShade,
    colorBands: ['#AA87D1', '#D9C6EF'],
    nonFiniteText: 'N/A',
    minHeight: 64,
    angularTickLabelPadding: 10,
    fallbackBandColor: base_colors_1.LIGHT_BASE_COLORS.mediumShade,
};
exports.DARK_THEME_BULLET_STYLE = {
    textColor: '#E0E5EE',
    border: base_colors_1.DARK_BASE_COLORS.lightShade,
    barBackground: '#FFF',
    colorBands: ['#6092C0', '#3F4E61'],
    nonFiniteText: 'N/A',
    minHeight: 64,
    angularTickLabelPadding: 10,
    fallbackBandColor: base_colors_1.DARK_BASE_COLORS.mediumShade,
};
exports.TITLE_FONT = {
    fontStyle: 'normal',
    fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
    fontVariant: 'normal',
    fontWeight: 'bold',
    textColor: 'black',
};
exports.TEXT_ASCENT_RATIO = 0.8;
exports.FONT_PADDING = 8;
exports.TITLE_FONT_SIZE = 16;
exports.TITLE_FONT_ASCENT = exports.TITLE_FONT_SIZE * exports.TEXT_ASCENT_RATIO;
exports.TITLE_LINE_SPACING = 4;
exports.SUBTITLE_FONT = {
    ...exports.TITLE_FONT,
    fontWeight: 'normal',
};
exports.SUBTITLE_FONT_SIZE = 14;
exports.SUBTITLE_FONT_ASCENT = exports.SUBTITLE_FONT_SIZE * exports.TEXT_ASCENT_RATIO;
exports.VALUE_FONT = {
    ...exports.TITLE_FONT,
};
exports.VALUE_FONT_SIZE = 22;
const VALUE_FONT_ASCENT = exports.VALUE_FONT_SIZE * exports.TEXT_ASCENT_RATIO;
exports.TARGET_FONT = {
    ...exports.SUBTITLE_FONT,
};
exports.TARGET_FONT_SIZE = 16;
const TARGET_FONT_ASCENT = exports.TARGET_FONT_SIZE * exports.TEXT_ASCENT_RATIO;
const getMaxTargetValueAssent = (target) => !target ? VALUE_FONT_ASCENT : Math.max(VALUE_FONT_ASCENT, TARGET_FONT_ASCENT);
exports.getMaxTargetValueAssent = getMaxTargetValueAssent;
exports.TICK_FONT = {
    ...exports.TITLE_FONT,
    fontWeight: 'normal',
};
exports.TICK_FONT_SIZE = 10;
exports.HEADER_PADDING = {
    top: 8,
    bottom: 10,
    left: 8,
    right: 8,
};
exports.GRAPH_PADDING = {
    top: 8,
    bottom: 8,
    left: 8,
    right: 8,
};
function getTextAscentHeight(fontSize, lines = 1, lineSpacing = 0) {
    return lines * (fontSize * exports.TEXT_ASCENT_RATIO) + (lines - 1) * lineSpacing;
}
//# sourceMappingURL=theme.js.map