"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verticalBullet = verticalBullet;
const text_utils_1 = require("../../../../../common/text_utils");
const common_1 = require("../../../../../utils/common");
const theme_1 = require("../../../theme");
const constants_1 = require("../constants");
function verticalBullet(ctx, dimensions, style, backgroundColor, activeValue) {
    ctx.translate(0, theme_1.GRAPH_PADDING.top);
    const { datum, graphArea, scale, colorBands, ticks } = dimensions;
    const [start, end] = scale.domain();
    const [min, max] = (0, common_1.sortNumbers)([start, end]);
    const graphPaddedHeight = graphArea.size.height - theme_1.GRAPH_PADDING.bottom - theme_1.GRAPH_PADDING.top;
    colorBands.reverse().forEach((band) => {
        ctx.fillStyle = band.color;
        ctx.fillRect(graphArea.size.width / 2 - constants_1.BULLET_SIZE / 2, graphPaddedHeight - band.start - band.size, constants_1.BULLET_SIZE, band.size);
    });
    ctx.beginPath();
    ctx.strokeStyle = backgroundColor;
    ctx.lineWidth = constants_1.TICK_WIDTH;
    ticks
        .filter((tick) => tick > min && tick < max)
        .forEach((tick) => {
        ctx.moveTo(graphArea.size.width / 2 - constants_1.BULLET_SIZE / 2, graphPaddedHeight - scale(tick));
        ctx.lineTo(graphArea.size.width / 2 + constants_1.BULLET_SIZE / 2, graphPaddedHeight - scale(tick));
    });
    ctx.stroke();
    const confinedValue = (0, common_1.clamp)(datum.value, min, max);
    const adjustedZero = (0, common_1.clamp)(0, min, max);
    ctx.fillStyle = style.barBackground;
    ctx.fillRect(graphArea.size.width / 2 - constants_1.BAR_SIZE / 2, confinedValue > 0 ? graphPaddedHeight - scale(confinedValue) : graphPaddedHeight - scale(adjustedZero), constants_1.BAR_SIZE, confinedValue > 0 ? scale(confinedValue) - scale(adjustedZero) : scale(adjustedZero) - scale(confinedValue));
    if ((0, common_1.isFiniteNumber)(datum.target) && datum.target <= max && datum.target >= min) {
        ctx.fillRect(graphArea.size.width / 2 - constants_1.TARGET_SIZE / 2, graphPaddedHeight - scale(datum.target) - constants_1.TARGET_STROKE_WIDTH / 2, constants_1.TARGET_SIZE, constants_1.TARGET_STROKE_WIDTH);
    }
    if ((0, common_1.isBetween)(min, max, true)(0)) {
        ctx.fillRect(graphArea.size.width / 2 - constants_1.BULLET_SIZE / 2, graphPaddedHeight - scale(0) - constants_1.TICK_WIDTH / 2, constants_1.BULLET_SIZE, constants_1.TICK_WIDTH);
    }
    if (activeValue && (datum.syncCursor || !activeValue.external)) {
        ctx.fillRect(graphArea.size.width / 2 - constants_1.TARGET_SIZE / 2, graphPaddedHeight - activeValue.value - constants_1.TARGET_STROKE_WIDTH / 2, constants_1.TARGET_SIZE, constants_1.TARGET_STROKE_WIDTH);
    }
    ctx.textBaseline = 'top';
    ctx.fillStyle = style.textColor;
    ctx.font = (0, text_utils_1.cssFontShorthand)(theme_1.TICK_FONT, theme_1.TICK_FONT_SIZE);
    ticks
        .filter((tick) => tick >= min && tick <= max)
        .forEach((tick, i) => {
        var _a;
        ctx.textAlign = 'end';
        const labelText = datum.tickFormatter(tick);
        if (i === ticks.length - 1) {
            const availableHeight = Math.abs((start > end ? min : max) - ((_a = ticks.at(i)) !== null && _a !== void 0 ? _a : NaN));
            const labelHeight = theme_1.TICK_FONT_SIZE;
            ctx.textBaseline = labelHeight >= Math.abs(scale(availableHeight) - scale(0)) ? 'hanging' : 'bottom';
        }
        else {
            ctx.textBaseline = 'bottom';
        }
        ctx.fillText(labelText, graphArea.size.width / 2 - constants_1.TARGET_SIZE / 2 - constants_1.TICK_LABEL_PADDING, graphPaddedHeight - scale(tick));
    });
}
//# sourceMappingURL=vertical.js.map