"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateInvestigationResponseSchema = exports.updateInvestigationParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _investigation = require("./investigation");
var _schema = require("../schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateInvestigationParamsSchema = exports.updateInvestigationParamsSchema = _zod.z.object({
  path: _zod.z.object({
    investigationId: _zod.z.string()
  }),
  body: _zod.z.object({
    title: _zod.z.string(),
    status: _schema.statusSchema,
    params: _zod.z.object({
      timeRange: _zod.z.object({
        from: _zod.z.number(),
        to: _zod.z.number()
      })
    }),
    tags: _zod.z.array(_zod.z.string()),
    externalIncidentUrl: _zod.z.string().nullable(),
    rootCauseAnalysis: _zod.z.object({
      events: _zod.z.array(_zod.z.any())
    })
  }).partial()
});
const updateInvestigationResponseSchema = exports.updateInvestigationResponseSchema = _investigation.investigationResponseSchema;