"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventsResponseSchema = exports.getEventsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEventsParamsSchema = exports.getEventsParamsSchema = _zod.z.object({
  query: _zod.z.object({
    rangeFrom: _zod.z.string(),
    rangeTo: _zod.z.string(),
    filter: _zod.z.string(),
    eventTypes: _zod.z.string().transform((val, ctx) => {
      const eventTypes = val.split(',');
      const hasInvalidType = eventTypes.some(eventType => !_schema.eventTypeSchema.parse(eventType));
      if (hasInvalidType) {
        ctx.addIssue({
          code: _zod.z.ZodIssueCode.custom,
          message: 'Invalid event type'
        });
        return _zod.z.NEVER;
      }
      return val.split(',').map(v => _schema.eventTypeSchema.parse(v));
    })
  }).partial()
}).partial();
const getEventsResponseSchema = exports.getEventsResponseSchema = _zod.z.array(_schema.eventSchema);