"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntitiesResponseSchema = exports.getEntitiesParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _entity = require("./entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntitiesParamsSchema = exports.getEntitiesParamsSchema = _zod.z.object({
  query: _zod.z.object({
    'service.name': _zod.z.string(),
    'service.environment': _zod.z.string(),
    'host.name': _zod.z.string(),
    'container.id': _zod.z.string()
  }).partial()
}).partial();
const getEntitiesResponseSchema = exports.getEntitiesResponseSchema = _zod.z.object({
  entities: _zod.z.array(_entity.entityWithSourceSchema)
});