"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityWithSourceSchema = exports.entitySchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsSchema = _zod.z.object({
  failedTransactionRate: _zod.z.number().optional(),
  latency: _zod.z.number().optional(),
  throughput: _zod.z.number().optional(),
  logErrorRate: _zod.z.number().optional(),
  logRate: _zod.z.number().optional()
});
const entitySchema = exports.entitySchema = _zod.z.object({
  id: _zod.z.string(),
  definition_id: _zod.z.string(),
  definition_version: _zod.z.string(),
  display_name: _zod.z.string(),
  last_seen_timestamp: _zod.z.string(),
  identity_fields: _zod.z.array(_zod.z.string()),
  schema_version: _zod.z.string(),
  type: _zod.z.string(),
  metrics: metricsSchema
});
const entitySourceSchema = _zod.z.object({
  dataStream: _zod.z.string().optional()
});
const entityWithSourceSchema = exports.entityWithSourceSchema = _zod.z.intersection(entitySchema, _zod.z.object({
  sources: _zod.z.array(entitySourceSchema)
}));