"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigationItem = createInvestigationItem;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createInvestigationItem(investigationId, params, {
  repository,
  user
}) {
  const investigation = await repository.findById(investigationId);
  const now = Date.now();
  const investigationItem = {
    id: (0, _uuid.v4)(),
    createdBy: user.profile_uid,
    createdAt: now,
    updatedAt: now,
    ...params
  };
  investigation.items.push(investigationItem);
  await repository.save(investigation);
  return investigationItem;
}