"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigation = createInvestigation;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createInvestigation(params, {
  repository,
  user
}) {
  if (await investigationAlreadyExists(params.id, repository)) {
    throw new Error(`Investigation [id=${params.id}] already exists`);
  }
  const now = Date.now();
  const investigation = {
    ...params,
    updatedAt: now,
    createdAt: now,
    createdBy: user.profile_uid,
    status: 'triage',
    notes: [],
    items: []
  };
  await repository.save(investigation);
  return investigation;
}
async function investigationAlreadyExists(investigationId, repository) {
  try {
    await repository.findById(investigationId);
    return true;
  } catch (err) {
    // TODO assert on error type/message
    return false;
  }
}