"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_ENTITIES_LATEST_ALIAS = exports.HOST_ENTITIES_LATEST_ALIAS = exports.CONTAINER_ENTITIES_LATEST_ALIAS = void 0;
exports.cancelEsRequestOnAbort = cancelEsRequestOnAbort;
exports.createEntitiesESClient = createEntitiesESClient;
var _entitiesSchema = require("@kbn/entities-schema");
var _unwrap_es_response = require("@kbn/observability-plugin/common/utils/unwrap_es_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE_ENTITIES_LATEST_ALIAS = exports.SERVICE_ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: 'service',
  dataset: _entitiesSchema.ENTITY_LATEST
});
const HOST_ENTITIES_LATEST_ALIAS = exports.HOST_ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: 'host',
  dataset: _entitiesSchema.ENTITY_LATEST
});
const CONTAINER_ENTITIES_LATEST_ALIAS = exports.CONTAINER_ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: 'container',
  dataset: _entitiesSchema.ENTITY_LATEST
});
function cancelEsRequestOnAbort(promise, request, controller) {
  const subscription = request.events.aborted$.subscribe(() => {
    controller.abort();
  });
  return promise.finally(() => subscription.unsubscribe());
}
function createEntitiesESClient({
  request,
  esClient
}) {
  function search(indexName, searchRequest) {
    const controller = new AbortController();
    const promise = cancelEsRequestOnAbort(esClient.search({
      ...searchRequest,
      index: [indexName],
      ignore_unavailable: true
    }, {
      signal: controller.signal,
      meta: true
    }), request, controller);
    return (0, _unwrap_es_response.unwrapEsResponse)(promise);
  }
  return {
    async search(entityIndexAlias, searchRequest) {
      return search(entityIndexAlias, searchRequest);
    },
    async msearch(allSearches) {
      const searches = allSearches.map(params => {
        const searchParams = [{
          index: [params.index],
          ignore_unavailable: true
        }, {
          ...params.body
        }];
        return searchParams;
      }).flat();
      const promise = esClient.msearch({
        searches
      }, {
        meta: true
      });
      const {
        body
      } = await promise;
      return {
        responses: body.responses
      };
    }
  };
}