"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationDetailsPage = InvestigationDetailsPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _investigation_not_found = require("../../components/investigation_not_found/investigation_not_found");
var _use_fetch_investigation = require("../../hooks/use_fetch_investigation");
var _use_kibana = require("../../hooks/use_kibana");
var _investigation_details = require("./components/investigation_details/investigation_details");
var _investigation_context = require("./contexts/investigation_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationDetailsPage() {
  const {
    core: {
      security
    }
  } = (0, _use_kibana.useKibana)();
  const {
    investigationId
  } = (0, _reactRouterDom.useParams)();
  const user = (0, _useAsync.default)(() => {
    return security.authc.getCurrentUser();
  }, [security]);
  const {
    data: investigation,
    isLoading: isFetchInvestigationLoading,
    isError: isFetchInvestigationError
  } = (0, _use_fetch_investigation.useFetchInvestigation)({
    id: investigationId
  });
  if (isFetchInvestigationLoading || user.loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  if (isFetchInvestigationError || !investigation || !user.value) {
    return /*#__PURE__*/_react.default.createElement(_investigation_not_found.InvestigationNotFound, null);
  }
  return /*#__PURE__*/_react.default.createElement(_investigation_context.InvestigationProvider, {
    initialInvestigation: investigation
  }, /*#__PURE__*/_react.default.createElement(_investigation_details.InvestigationDetails, {
    user: user.value
  }));
}