"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationEventTypesFilter = InvestigationEventTypesFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationEventTypesFilter({
  onSelected
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([{
    key: 'alert',
    label: _i18n.i18n.translate('xpack.investigateApp.investigationEventTypesFilter.alertLabel', {
      defaultMessage: 'Alert'
    }),
    checked: 'on'
  }, {
    key: 'annotation',
    label: _i18n.i18n.translate('xpack.investigateApp.investigationEventTypesFilter.annotationLabel', {
      defaultMessage: 'Annotation'
    }),
    checked: 'on'
  }]);
  const togglePopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const handleChange = newOptions => {
    setItems(newOptions);
    const selected = newOptions.filter(option => option.checked === 'on').map(option => option.key);
    onSelected(selected);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: false,
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: togglePopover,
    isSelected: isPopoverOpen,
    numFilters: items.filter(item => item.checked !== 'off').length,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    numActiveFilters: items.filter(item => item.checked === 'on').length
  }, _i18n.i18n.translate('xpack.investigateApp.investigationEventTypesFilter.filtersFilterButtonLabel', {
    defaultMessage: 'Filters'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: items,
    onChange: handleChange
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.investigateApp.investigationEventTypesFilter.filterEventTypePopoverTitleLabel', {
    defaultMessage: 'Filter event type'
  })), list))));
}