"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationHeader = InvestigationHeader;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _dateFns = require("date-fns");
var _react = _interopRequireDefault(require("react"));
var _investigation_status_badge = require("../../../../components/investigation_status_badge/investigation_status_badge");
var _investigation_tag = require("../../../../components/investigation_tag/investigation_tag");
var _investigation_context = require("../../contexts/investigation_context");
var _alert_details_button = require("./alert_details_button");
var _external_incident_button = require("./external_incident_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

function InvestigationHeader() {
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  if (!investigation) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_details_button.AlertDetailsButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, investigation.title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_investigation_status_badge.InvestigationStatusBadge, {
    status: investigation.status
  })), investigation.tags.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "s"
  }, investigation.tags.map(tag => /*#__PURE__*/_react.default.createElement(_investigation_tag.InvestigationTag, {
    key: tag,
    tag: tag
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.investigateApp.investigationHeader.startedLabel",
    defaultMessage: "Started: {timeAgo}",
    values: {
      timeAgo: /*#__PURE__*/_react.default.createElement("strong", null, (0, _dateFns.formatDistance)(new Date(investigation.createdAt), new Date(), {
        addSuffix: true
      }))
    }
  }))), !!investigation.externalIncidentUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_external_incident_button.ExternalIncidentButton, null))));
}