"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQL_ITEM_TYPE = void 0;
exports.EsqlWidget = EsqlWidget;
exports.registerEsqlItem = registerEsqlItem;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_abortable_async = require("@kbn/observability-utils-browser/hooks/use_abortable_async");
var _react = _interopRequireWildcard(require("react"));
var _error_message = require("../../components/error_message");
var _use_kibana = require("../../hooks/use_kibana");
var _get_data_table_from_esql_response = require("../../utils/get_data_table_from_esql_response");
var _get_es_filter_from_overrides = require("../../utils/get_es_filter_from_overrides");
var _get_lens_attrs_for_suggestion = require("../../utils/get_lens_attrs_for_suggestion");
var _get_date_histogram_results = require("./get_date_histogram_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_ITEM_TYPE = exports.ESQL_ITEM_TYPE = 'esql';
function EsqlWidget({
  suggestion,
  dataView,
  esqlQuery,
  dateHistogramResults
}) {
  const {
    dependencies: {
      start: {
        lens
      }
    }
  } = (0, _use_kibana.useKibana)();
  const input = (0, _react.useMemo)(() => {
    return (0, _get_lens_attrs_for_suggestion.getLensAttrsForSuggestion)({
      suggestion,
      dataView,
      query: esqlQuery
    });
  }, [suggestion, dataView, esqlQuery]);
  const previewInput = (0, _use_abortable_async.useAbortableAsync)(async ({
    signal
  }) => {
    if (!dateHistogramResults) {
      return undefined;
    }
    const lensHelper = await lens.stateHelperApi();
    const suggestionsFromLensHelper = await lensHelper.suggestions({
      dataViewSpec: dataView.toSpec(),
      fieldName: '',
      textBasedColumns: [{
        id: dateHistogramResults.groupingExpression,
        name: _i18n.i18n.translate('xpack.investigateApp.esqlWidget.groupedByDateLabel', {
          defaultMessage: '@timestamp'
        }),
        meta: {
          type: 'date'
        }
      }, {
        id: 'count',
        name: 'count',
        meta: {
          type: 'number'
        }
      }],
      query: {
        esql: dateHistogramResults.query
      }
    }, dataView, ['lnsDatatable']);
    const suggestionForHistogram = suggestionsFromLensHelper === null || suggestionsFromLensHelper === void 0 ? void 0 : suggestionsFromLensHelper[0];
    if (!suggestionForHistogram) {
      return undefined;
    }
    return (0, _get_lens_attrs_for_suggestion.getLensAttrsForSuggestion)({
      suggestion: suggestionForHistogram,
      dataView,
      query: dateHistogramResults.query,
      table: (0, _get_data_table_from_esql_response.getDatatableFromEsqlResponse)({
        columns: dateHistogramResults.columns,
        values: dateHistogramResults.values
      })
    });
  }, [dataView, lens, dateHistogramResults]);

  // in the case of a lnsDatatable, we want to render the preview of the histogram and not the datable (input) itself
  if (input.attributes.visualizationType === 'lnsDatatable') {
    let innerElement;
    if (previewInput.error) {
      innerElement = /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
        error: previewInput.error
      });
    } else if (previewInput.value) {
      innerElement = /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, previewInput.value, {
        style: {
          height: 128
        },
        overrides: {
          axisX: {
            hide: true
          },
          axisLeft: {
            style: {
              axisTitle: {
                visible: false
              }
            }
          },
          settings: {
            showLegend: false
          }
        }
      }));
    } else {
      innerElement = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "s"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, innerElement);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, input, {
    style: {
      height: 128
    },
    overrides: {
      axisX: {
        hide: true
      },
      axisLeft: {
        style: {
          axisTitle: {
            visible: false
          }
        }
      },
      settings: {
        showLegend: false
      }
    }
  })));
}
function registerEsqlItem({
  dependencies: {
    setup: {
      investigate
    }
  },
  services
}) {
  investigate.registerItemDefinition({
    type: ESQL_ITEM_TYPE,
    generate: async option => {
      const controller = new AbortController();
      const {
        esql: esqlQuery,
        suggestion: suggestionFromParameters
      } = option.itemParams;
      const {
        timeRange
      } = option.globalParams;
      const esql = await services.esql;
      const esFilters = [(0, _get_es_filter_from_overrides.getEsFilterFromOverrides)({
        timeRange
      })];
      const getFilter = () => ({
        bool: {
          filter: [...esFilters]
        }
      });
      const mainResponse = await esql.queryWithMeta({
        query: esqlQuery,
        signal: controller.signal,
        filter: getFilter()
      });
      const suggestion = suggestionFromParameters || mainResponse.meta.suggestions[0];
      const dateHistoResponse = await (0, _get_date_histogram_results.getDateHistogramResults)({
        query: esqlQuery,
        columns: mainResponse.query.columns,
        esql,
        filter: getFilter(),
        signal: controller.signal,
        suggestion,
        timeRange
      });
      return {
        dataView: mainResponse.meta.dataView,
        suggestion,
        dateHistoResponse
      };
    },
    render: option => {
      const {
        itemParams,
        data
      } = option;
      return /*#__PURE__*/_react.default.createElement(EsqlWidget, {
        dataView: data.dataView,
        suggestion: data.suggestion,
        esqlQuery: itemParams.esql,
        dateHistogramResults: data.dateHistoResponse
      });
    }
  });
}