"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchUserProfiles = useFetchUserProfiles;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchUserProfiles({
  profileIds
}) {
  const {
    core: {
      notifications: {
        toasts
      },
      userProfile
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.userProfiles(profileIds),
    queryFn: async () => {
      const userProfiles = await userProfile.bulkGet({
        uids: profileIds
      });
      return (0, _lodash.keyBy)(userProfiles, 'uid');
    },
    enabled: profileIds.size > 0,
    retry: false,
    cacheTime: Infinity,
    staleTime: Infinity,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchUserProfiles.errorTitle', {
          defaultMessage: 'Something went wrong while fetching user profiles'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}