"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchInvestigationItems = useFetchInvestigationItems;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchInvestigationItems({
  investigationId
}) {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.detailItems(investigationId),
    queryFn: async ({
      signal
    }) => {
      return await http.get(`/api/observability/investigations/${investigationId}/items`, {
        version: '2023-10-31',
        signal
      });
    },
    refetchOnWindowFocus: false,
    refetchInterval: 10 * 1000,
    refetchIntervalInBackground: true,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchInvestigationItems.errorTitle', {
          defaultMessage: 'Something went wrong while fetching investigation items'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}