"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchEvents = useFetchEvents;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchEvents({
  rangeFrom,
  rangeTo,
  filter,
  eventTypes
}) {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isLoading,
    isError,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.events({
      rangeFrom,
      rangeTo,
      filter,
      eventTypes
    }),
    queryFn: async ({
      signal
    }) => {
      return http.get(`/api/observability/events`, {
        query: {
          rangeFrom,
          rangeTo,
          filter,
          ...((0, _lodash.isArray)(eventTypes) && eventTypes.length > 0 && {
            eventTypes: eventTypes.join(',')
          })
        },
        version: '2023-10-31',
        signal
      });
    },
    refetchOnWindowFocus: false,
    retry: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.events.fetch.error', {
          defaultMessage: 'Something went wrong while fetching the events'
        })
      });
    }
  });
  return {
    data,
    isLoading,
    isError
  };
}