"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchEntities = useFetchEntities;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchEntities({
  investigationId,
  serviceName,
  serviceEnvironment,
  hostName,
  containerId
}) {
  const {
    core: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.entities({
      investigationId,
      serviceName,
      serviceEnvironment,
      hostName,
      containerId
    }),
    queryFn: async ({
      signal
    }) => {
      return await http.get('/api/observability/investigation/entities', {
        query: {
          'service.name': serviceName,
          'service.environment': serviceEnvironment,
          'host.name': hostName,
          'container.id': containerId
        },
        version: '2023-10-31',
        signal
      });
    },
    refetchOnWindowFocus: false,
    retry: false,
    enabled: Boolean(investigationId && (serviceName || hostName || containerId))
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}