"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddInvestigationNote = useAddInvestigationNote;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAddInvestigationNote() {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['addInvestigationNote'], ({
    investigationId,
    note
  }) => {
    const body = JSON.stringify(note);
    return http.post(`/api/observability/investigations/${investigationId}/notes`, {
      body,
      version: '2023-10-31'
    });
  }, {
    onSuccess: (_, {
      investigationId
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.investigationKeys.detailNotes(investigationId),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.investigateApp.addInvestigationNote.successMessage', {
        defaultMessage: 'Note saved'
      }));
    },
    onError: (error, {}, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.investigateApp.addInvestigationNote.errorMessage', {
        defaultMessage: 'an error occurred'
      })), {
        title: _i18n.i18n.translate('xpack.investigateApp.addInvestigationNote.errorTitle', {
          defaultMessage: 'Error'
        })
      });
    }
  });
}