"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

'investigations,list,{page:1,perPage:25}';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.investigationKeys = void 0;
const investigationKeys = exports.investigationKeys = {
  all: ['investigations'],
  userProfiles: profileIds => [...investigationKeys.all, 'userProfiles', ...profileIds],
  tags: () => [...investigationKeys.all, 'tags'],
  events: params => [...investigationKeys.all, 'events', params],
  stats: () => [...investigationKeys.all, 'stats'],
  lists: () => [...investigationKeys.all, 'list'],
  list: params => [...investigationKeys.lists(), params],
  details: () => [...investigationKeys.all, 'detail'],
  detail: investigationId => [...investigationKeys.details(), investigationId],
  detailNotes: investigationId => [...investigationKeys.detail(investigationId), 'notes'],
  detailItems: investigationId => [...investigationKeys.detail(investigationId), 'items'],
  entities: ({
    investigationId,
    ...params
  }) => [...investigationKeys.detail(investigationId), 'entities', params]
};