"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsField = TagsField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_all_investigation_tags = require("../../../hooks/use_fetch_all_investigation_tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18N_TAGS_LABEL = _i18n.i18n.translate('xpack.investigateApp.investigationEditForm.span.tagsLabel', {
  defaultMessage: 'Tags'
});
function TagsField() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    isLoading,
    data: tags
  } = (0, _use_fetch_all_investigation_tags.useFetchAllInvestigationTags)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: I18N_TAGS_LABEL,
    fullWidth: true,
    isInvalid: getFieldState('tags').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "tags",
    defaultValue: [],
    rules: {
      required: false
    },
    render: ({
      field,
      fieldState
    }) => {
      var _tags$map;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        "aria-label": I18N_TAGS_LABEL,
        placeholder: I18N_TAGS_LABEL,
        fullWidth: true,
        isInvalid: fieldState.invalid,
        isClearable: true,
        isLoading: isLoading,
        options: (_tags$map = tags === null || tags === void 0 ? void 0 : tags.map(tag => ({
          label: tag,
          value: tag
        }))) !== null && _tags$map !== void 0 ? _tags$map : [],
        selectedOptions: generateTagOptions(field.value),
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected.map(opts => opts.value));
          }
          field.onChange([]);
        },
        onCreateOption: searchValue => {
          var _field$value;
          const normalizedSearchValue = searchValue.trim().toLowerCase();
          if (!normalizedSearchValue) {
            return;
          }
          const values = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : [];
          const tagAlreadyExists = values.find(tag => tag.trim().toLowerCase() === normalizedSearchValue);
          if (!tagAlreadyExists) {
            field.onChange([...values, searchValue]);
          }
        }
      }));
    }
  }));
}
function generateTagOptions(tags = []) {
  return tags.map(tag => ({
    label: tag,
    value: tag
  }));
}