"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listLatestEntitiesRoute = exports.getEntityTypesRoute = exports.entitiesRoutes = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _es_fields = require("@kbn/dataset-quality-plugin/common/es_fields");
var _join_by_key = require("@kbn/observability-utils-common/array/join_by_key");
var _common = require("@kbn/observability-shared-plugin/common");
var _entities = require("../../../common/entities");
var _create_inventory_server_route = require("../create_inventory_server_route");
var _create_alerts_client = require("../../lib/create_alerts_client/create_alerts_client");
var _get_latest_entities_alerts = require("./get_latest_entities_alerts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityTypesRoute = exports.getEntityTypesRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/entities/types',
  params: t.partial({
    query: t.partial({
      includeEntityTypes: _ioTsUtils.jsonRt.pipe(t.array(t.string)),
      excludeEntityTypes: _ioTsUtils.jsonRt.pipe(t.array(t.string)),
      kuery: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['inventory']
    }
  },
  handler: async ({
    plugins,
    request,
    params
  }) => {
    var _params$query;
    const entityManagerStart = await plugins.entityManager.start();
    const entityManagerClient = await entityManagerStart.getScopedClient({
      request
    });
    const {
      includeEntityTypes,
      excludeEntityTypes,
      kuery
    } = (_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : {};
    const rawEntityTypes = await entityManagerClient.v2.readTypeDefinitions();
    const hasIncludedEntityTypes = (includeEntityTypes !== null && includeEntityTypes !== void 0 ? includeEntityTypes : []).length > 0;
    const entityTypes = rawEntityTypes.filter(entityType => hasIncludedEntityTypes ? includeEntityTypes === null || includeEntityTypes === void 0 ? void 0 : includeEntityTypes.includes(entityType.id) : !(excludeEntityTypes !== null && excludeEntityTypes !== void 0 && excludeEntityTypes.includes(entityType.id)));
    const entityCount = await entityManagerClient.v2.countEntities({
      start: (0, _moment.default)().subtract(15, 'm').toISOString(),
      end: (0, _moment.default)().toISOString(),
      types: entityTypes.map(entityType => entityType.id),
      filters: kuery ? [kuery] : undefined
    });
    const entityTypesWithCount = entityTypes.map(entityType => ({
      ...entityType,
      count: entityCount.types[entityType.id]
    })).filter(entityType => entityType.count > 0);
    return {
      entityTypes: entityTypesWithCount,
      totalEntities: entityCount.total
    };
  }
});
const listLatestEntitiesRoute = exports.listLatestEntitiesRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/entities',
  params: t.type({
    query: t.intersection([t.type({
      sortField: _entities.entityColumnIdsRt,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
      entityType: t.string
    }), t.partial({
      kuery: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['inventory']
    }
  },
  handler: async ({
    params,
    plugins,
    request,
    logger,
    context
  }) => {
    const entityManagerStart = await plugins.entityManager.start();
    const {
      client: clusterClient
    } = (await context.core).elasticsearch;
    const {
      sortDirection,
      sortField,
      kuery,
      entityType
    } = params.query;
    const [entityManagerClient, alertsClient] = await Promise.all([entityManagerStart.getScopedClient({
      request
    }), (0, _create_alerts_client.createAlertsClient)({
      plugins,
      request
    })]);
    const METADATA_BY_TYPE = {
      default: [_es_fields.DATA_STREAM_TYPE],
      [_common.BUILT_IN_ENTITY_TYPES.CONTAINER_V2]: [_es_fields.DATA_STREAM_TYPE, 'cloud.provider'],
      [_common.BUILT_IN_ENTITY_TYPES.HOST_V2]: [_es_fields.DATA_STREAM_TYPE, 'cloud.provider'],
      [_common.BUILT_IN_ENTITY_TYPES.SERVICE_V2]: [_es_fields.DATA_STREAM_TYPE, 'agent.name']
    };
    const [{
      entities: rawEntities
    }, identityFieldsBySource] = await Promise.all([entityManagerClient.v2.searchEntities({
      start: (0, _moment.default)().subtract(15, 'm').toISOString(),
      end: (0, _moment.default)().toISOString(),
      limit: _entities.MAX_NUMBER_OF_ENTITIES,
      type: entityType,
      metadata_fields: METADATA_BY_TYPE[entityType] || METADATA_BY_TYPE.default,
      filters: kuery ? [kuery] : []
    }), entityManagerStart.v2.identityFieldsBySource(entityType, clusterClient, logger)]);
    const alerts = await (0, _get_latest_entities_alerts.getLatestEntitiesAlerts)({
      identityFieldsBySource,
      alertsClient
    });
    const entities = rawEntities.map(entity => {
      return {
        entityId: entity['entity.id'],
        entityType: entity['entity.type'],
        entityDisplayName: entity['entity.display_name'],
        entityLastSeenTimestamp: entity['entity.last_seen_timestamp'],
        entityIdentityFields: identityFieldsBySource,
        ...entity
      };
    });
    const joined = (0, _join_by_key.joinByKey)([...entities, ...alerts], [...Object.values(identityFieldsBySource)].flat()).filter(latestEntity => latestEntity.entityId);
    return {
      entities: sortField === 'alertsCount' ? (0, _lodash.orderBy)(joined, [item => (item === null || item === void 0 ? void 0 : item.alertsCount) === undefined, sortField], ['asc', sortDirection] // push entities without alertsCount to the end
      ) : joined
    };
  }
});
const entitiesRoutes = exports.entitiesRoutes = {
  ...listLatestEntitiesRoute,
  ...getEntityTypesRoute
};