"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInventoryDecodedQueryParams = useInventoryDecodedQueryParams;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _react = require("react");
var _rt_types = require("../../common/rt_types");
var _use_inventory_params = require("./use_inventory_params");
var _use_inventory_router = require("./use_inventory_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityTypeDecoder = (0, _ioTsUtils.decodeOrThrow)(_rt_types.entityTypesRt);
const paginationDecoder = (0, _ioTsUtils.decodeOrThrow)(_rt_types.entityPaginationRt);
function useInventoryDecodedQueryParams() {
  const inventoryRoute = (0, _use_inventory_router.useInventoryRouter)();
  const {
    query,
    query: {
      entityTypes,
      pagination
    }
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const resetUrlParam = (0, _react.useCallback)(queryParamName => {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        [queryParamName]: undefined
      }
    });
  }, [inventoryRoute, query]);
  const selectedEntityTypes = (0, _react.useMemo)(() => {
    try {
      return entityTypeDecoder(entityTypes) || {};
    } catch (e) {
      resetUrlParam('entityTypes');
      return {};
    }
  }, [entityTypes, resetUrlParam]);
  const selectedPagination = (0, _react.useMemo)(() => {
    try {
      return paginationDecoder(pagination) || {};
    } catch (error) {
      resetUrlParam('pagination');
      return {};
    }
  }, [pagination, resetUrlParam]);
  return {
    entityTypes: selectedEntityTypes,
    pagination: selectedPagination
  };
}