"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBySelector = GroupBySelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_TYPE_LABEL = _i18n.i18n.translate('xpack.inventory.groupedInventoryPage.typeLabel', {
  defaultMessage: 'Type'
});
function GroupBySelector() {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const panels = [{
    id: 'firstPanel',
    title: _i18n.i18n.translate('xpack.inventory.groupedInventoryPage.groupSelectorLabel', {
      defaultMessage: 'Select grouping'
    }),
    items: [{
      'data-test-subj': 'panelType',
      name: ENTITY_TYPE_LABEL,
      icon: 'check'
    }]
  }];
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentVal => !currentVal), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "groupSelectorDropdown",
    iconSide: "right",
    iconSize: "s",
    iconType: "arrowDown",
    onClick: onButtonClick,
    title: ENTITY_TYPE_LABEL,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.inventory.groupedInventoryPage.groupedByLabel",
    defaultMessage: `Group entities by: {grouping}`,
    values: {
      grouping: ENTITY_TYPE_LABEL
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "inventoryGroupsPopover",
    button: button,
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "entitiesGroupByContextMenu",
    initialPanelId: "firstPanel",
    panels: panels
  }));
}