"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityActions = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _use_discover_redirect = require("../../hooks/use_discover_redirect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityActions = ({
  entity,
  setShowActions
}) => {
  const [isPopoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const actionButtonTestSubject = entity.entityDisplayName ? `inventoryEntityActionsButton-${entity.entityDisplayName}` : 'inventoryEntityActionsButton';
  const {
    getDiscoverEntitiesRedirectUrl
  } = (0, _use_discover_redirect.useDiscoverRedirect)(entity);
  const discoverUrl = getDiscoverEntitiesRedirectUrl();
  const actions = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "inventoryEntityActionExploreInDiscover",
    key: `exploreInDiscover-${entity.entityDisplayName}`,
    color: "text",
    icon: "discoverApp",
    href: discoverUrl
  }, _i18n.i18n.translate('xpack.inventory.entityActions.exploreInDiscoverLink', {
    defaultMessage: 'Explore in Discover'
  }))];
  if (!discoverUrl) {
    setShowActions(false);
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    anchorPosition: "upCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": actionButtonTestSubject,
      "aria-label": _i18n.i18n.translate('xpack.inventory.entityActions.euiButtonIcon.showActionsLabel', {
        defaultMessage: 'Show actions'
      }),
      iconType: "boxesHorizontal",
      color: "text",
      onClick: togglePopover
    }),
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: actions,
    size: "s"
  }));
};
exports.EntityActions = EntityActions;