"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRedactVariables = getRedactVariables;
exports.getStateVarsAndDefaultValues = getStateVarsAndDefaultValues;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets a list of variables that require redaction from agent logs for the CEL input.
 */
function getRedactVariables(stateDetails) {
  const redact = [];
  for (const cVar of stateDetails) {
    if (cVar.redact) {
      redact.push(cVar.name);
    }
  }
  return redact;
}

/**
 * Gets an object containing state variables and their corresponding default values.
 */
function getStateVarsAndDefaultValues(stateDetails) {
  const defaultStateVarSettings = {};
  for (const stateVar of stateDetails) {
    defaultStateVarSettings[stateVar.name] = stateVar.default;
  }
  return defaultStateVarSettings;
}