"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _create_integration = require("./components/create_integration");
var _create_integration_card_button = require("./components/create_integration_card_button");
var _services = require("./services");
var _experimental_features = require("../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IntegrationAssistantPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "telemetry", new _services.Telemetry());
    (0, _defineProperty2.default)(this, "renderUpselling$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []);
    _services.ExperimentalFeaturesService.init(this.experimentalFeatures);
  }
  setup(core) {
    this.telemetry.setup(core.analytics);
    this.config = this.config;
    return {};
  }
  start(core, dependencies) {
    const services = {
      ...core,
      ...dependencies,
      telemetry: this.telemetry.start(),
      renderUpselling$: this.renderUpselling$.asObservable()
    };
    return {
      components: {
        CreateIntegration: (0, _create_integration.getCreateIntegrationLazy)(services),
        CreateIntegrationCardButton: (0, _create_integration_card_button.getCreateIntegrationCardButtonLazy)()
      },
      renderUpselling: renderUpselling => {
        this.renderUpselling$.next(renderUpselling);
      }
    };
  }
  stop() {}
}
exports.IntegrationAssistantPlugin = IntegrationAssistantPlugin;