"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiDefinitionInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _state = require("../../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiDefinitionInput = exports.ApiDefinitionInput = /*#__PURE__*/_react.default.memo(({
  integrationSettings
}) => {
  const {
    setIntegrationSettings
  } = (0, _state.useActions)();
  const [isParsing, setIsParsing] = (0, _react.useState)(false);
  const [apiFileError, setApiFileError] = (0, _react.useState)();
  const onChangeApiDefinition = (0, _react.useCallback)(files => {
    if (!files) {
      return;
    }
    setApiFileError(undefined);
    setIntegrationSettings({
      ...integrationSettings,
      apiDefinition: undefined
    });
    const apiDefinitionFile = files[0];
    const reader = new FileReader();
    reader.onloadstart = function () {
      setIsParsing(true);
    };
    reader.onloadend = function () {
      setIsParsing(false);
    };
    reader.onload = function (e) {
      var _e$target;
      const fileContent = (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result; // We can safely cast to string since we call `readAsText` to load the file.

      if (fileContent == null) {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ);
        return;
      }
      if (fileContent === '' && e.loaded > 100000) {
        // V8-based browsers can't handle large files and return an empty string
        // instead of an error; see https://stackoverflow.com/a/61316641
        setApiFileError(i18n.API_DEFINITION_ERROR.TOO_LARGE_TO_PARSE);
        return;
      }
      setIntegrationSettings({
        ...integrationSettings,
        apiDefinition: fileContent
      });
    };
    const handleReaderError = function () {
      var _reader$error;
      const message = (_reader$error = reader.error) === null || _reader$error === void 0 ? void 0 : _reader$error.message;
      if (message) {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ_WITH_REASON(message));
      } else {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ);
      }
    };
    reader.onerror = handleReaderError;
    reader.onabort = handleReaderError;
    reader.readAsText(apiDefinitionFile);
  }, [integrationSettings, setIntegrationSettings, setIsParsing]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.API_DEFINITION_LABEL,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "xs"
    }, apiFileError),
    isInvalid: apiFileError != null
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "apiDefinitionFilePicker",
    initialPromptText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center"
    }, i18n.API_DEFINITION_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      textAlign: "center"
    }, i18n.API_DEFINITION_DESCRIPTION_2)),
    onChange: onChangeApiDefinition,
    display: "large",
    "aria-label": "Upload API definition file",
    isLoading: isParsing,
    "data-test-subj": "apiDefinitionFilePicker",
    "data-loading": isParsing
  })));
});
ApiDefinitionInput.displayName = 'ApiDefinitionInput';