"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailabilityWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _license_paywall_card = require("./license_paywall_card");
var _use_availability = require("../../hooks/use_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AvailabilityWrapper = exports.AvailabilityWrapper = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const {
    hasLicense,
    renderUpselling
  } = (0, _use_availability.useAvailability)();
  if (renderUpselling) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderUpselling);
  }
  if (!hasLicense) {
    return /*#__PURE__*/_react.default.createElement(_license_paywall_card.LicensePaywallCard, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
AvailabilityWrapper.displayName = 'AvailabilityWrapper';