"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckManageProcessorsPrivileges = void 0;
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckManageProcessorsPrivileges = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const {
    isLoading,
    data: privilegesData
  } = services.api.useLoadManageProcessorsPrivileges();
  const hasPrivileges = privilegesData === null || privilegesData === void 0 ? void 0 : privilegesData.hasAllPrivileges;
  return isLoading ? false : !!hasPrivileges;
};
exports.useCheckManageProcessorsPrivileges = useCheckManageProcessorsPrivileges;