"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deepEqualIgnoreUndefined = deepEqualIgnoreUndefined;
exports.removeUndefinedValues = removeUndefinedValues;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function removeUndefinedValues(obj) {
  // If the input is an object, recursively clean each key-value pair.
  if ((0, _lodash.isObject)(obj)) {
    // Use transform to iterate over the object and build a new result object.
    return (0, _lodash.transform)(obj, (result, value, key) => {
      const cleanedValue = removeUndefinedValues(value);
      if (cleanedValue !== undefined) {
        // Only add the key-value pair if the value is not undefined.
        result[key] = cleanedValue;
      }
    }, {});
  }
  return obj;
}
function deepEqualIgnoreUndefined(obj1, obj2) {
  // Clean both objects by removing undefined values.
  const cleanedObj1 = removeUndefinedValues(obj1);
  const cleanedObj2 = removeUndefinedValues(obj2);
  return (0, _lodash.isEqual)(cleanedObj1, cleanedObj2);
}