"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentationButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentationButton = ({
  processorLabel,
  docLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLink,
    target: "_blank",
    iconType: "help"
  }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.settingsForm.learnMoreLabelLink.processor', {
    defaultMessage: '{processorLabel} documentation',
    values: {
      processorLabel
    }
  }));
};
exports.DocumentationButton = DocumentationButton;