"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddProcessorButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addProcessorButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addProcessorButtonLabel', {
  defaultMessage: 'Add a processor'
});
const AddProcessorButton = props => {
  const {
    onClick,
    renderButtonAsLink
  } = props;
  const {
    state: {
      editor
    }
  } = (0, _context.usePipelineProcessorsContext)();
  if (renderButtonAsLink) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "addProcessorButton",
      disabled: editor.mode.id !== 'idle',
      iconSide: "left",
      iconType: "plusInCircle",
      onClick: onClick
    }, addProcessorButtonLabel);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addProcessorButton",
    className: "pipelineProcessorsEditor__tree__addProcessorButton",
    disabled: editor.mode.id !== 'idle',
    onClick: onClick
  }, addProcessorButtonLabel);
};
exports.AddProcessorButton = AddProcessorButton;