"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.excess = exports.buildRouteValidationWithExcess = void 0;
var _Either = require("fp-ts/lib/Either");
var _get = _interopRequireDefault(require("lodash/get"));
var _pipeable = require("fp-ts/lib/pipeable");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildRouteValidationWithExcess = schema => (inputValue, validationResult) => (0, _pipeable.pipe)(excess(schema).decode(inputValue), (0, _Either.fold)(errors => validationResult.badRequest((0, _securitysolutionIoTsUtils.formatErrors)(errors).join()), validatedInput => validationResult.ok(validatedInput)));
exports.buildRouteValidationWithExcess = buildRouteValidationWithExcess;
const excess = codec => {
  const codecProps = getProps(codec);
  const r = new rt.InterfaceType(codec.name, codec.is, (i, c) => _Either.either.chain(rt.UnknownRecord.validate(i, c), s => {
    if (codecProps == null) {
      return rt.failure(i, c, 'unknown codec');
    }
    const ex = getExcessProps(codecProps, s);
    return ex.length > 0 ? rt.failure(i, c, `Invalid value ${JSON.stringify(i)}, excess properties: ${JSON.stringify(ex)}`) : codec.validate(i, c);
  }), codec.encode, codecProps);
  return r;
};
exports.excess = excess;
const getExcessProps = (props, r) => {
  return Object.keys(r).reduce((acc, k) => {
    const codecChildren = (0, _get.default)(props, [k]);
    const childrenProps = getProps(codecChildren);
    const childrenObject = r[k];
    if (codecChildren != null && childrenProps != null && codecChildren._tag === 'DictionaryType') {
      const keys = Object.keys(childrenObject);
      return [...acc, ...keys.reduce((kAcc, i) => [...kAcc, ...getExcessProps(childrenProps, childrenObject[i])], [])];
    }
    if (codecChildren != null && childrenProps != null) {
      return [...acc, ...getExcessProps(childrenProps, childrenObject)];
    } else if (codecChildren == null) {
      return [...acc, k];
    }
    return acc;
  }, []);
};
const getProps = codec => {
  if (codec == null) {
    return null;
  }
  switch (codec._tag) {
    case 'DictionaryType':
      {
        if (codec.codomain.props != null) {
          return codec.codomain.props;
        }
        const dTypes = codec.codomain.types;
        return dTypes.reduce((props, type) => Object.assign(props, getProps(type)), {});
      }
    case 'RefinementType':
    case 'ReadonlyType':
      return getProps(codec.type);
    case 'ExactType':
      return getProps(codec.type);
    case 'InterfaceType':
    case 'PartialType':
      return codec.props;
    case 'IntersectionType':
      {
        const iTypes = codec.types;
        return iTypes.reduce((props, type) => {
          const typeProps = getProps(type);
          return Object.assign(props, typeProps);
        }, {});
      }
    default:
      return null;
  }
};