"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSourceToLogView = exports.getAttributesFromSourceConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapSourceToLogView = sourceConfiguration => {
  return {
    id: sourceConfiguration.id,
    version: sourceConfiguration.version,
    updatedAt: sourceConfiguration.updatedAt,
    origin: `infra-source-${sourceConfiguration.origin}`,
    attributes: getAttributesFromSourceConfiguration(sourceConfiguration)
  };
};
exports.mapSourceToLogView = mapSourceToLogView;
const getAttributesFromSourceConfiguration = ({
  configuration: {
    name,
    description,
    logIndices,
    logColumns
  }
}) => ({
  name,
  description,
  logIndices: getLogIndicesFromSourceConfigurationLogIndices(logIndices),
  logColumns
});
exports.getAttributesFromSourceConfiguration = getAttributesFromSourceConfiguration;
const getLogIndicesFromSourceConfigurationLogIndices = logIndices => logIndices.type === 'index_pattern' ? {
  type: 'data_view',
  dataViewId: logIndices.indexPatternId
} : logIndices;