"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSnapshotRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _constants = require("../../../common/constants");
var _usage_collector = require("../../usage/usage_collector");
var _snapshot_api = require("../../../common/http_api/snapshot_api");
var _create_search_client = require("../../lib/create_search_client");
var _get_nodes = require("./lib/get_nodes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initSnapshotRoute = libs => {
  const validateBody = (0, _ioTsUtils.createRouteValidationFunction)(_snapshot_api.SnapshotRequestRT);
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'post',
    path: '/api/metrics/snapshot',
    validate: {
      body: validateBody
    }
  }, async (requestContext, request, response) => {
    const snapshotRequest = request.body;
    try {
      if (snapshotRequest.metrics.length > _constants.SNAPSHOT_API_MAX_METRICS) {
        throw _boom.default.badRequest(`'metrics' size is greater than maximum of ${_constants.SNAPSHOT_API_MAX_METRICS} allowed.`);
      }
      const soClient = (await requestContext.core).savedObjects.client;
      const source = await libs.sources.getSourceConfiguration(soClient, snapshotRequest.sourceId);
      const compositeSize = libs.configuration.inventory.compositeSize;
      const [, {
        logsShared
      }] = await libs.getStartServices();
      const logQueryFields = await logsShared.logViews.getScopedClient(request).getResolvedLogView({
        type: 'log-view-reference',
        logViewId: snapshotRequest.sourceId
      }).then(({
        indices
      }) => ({
        indexPattern: indices
      }), () => undefined);
      _usage_collector.UsageCollector.countNode(snapshotRequest.nodeType);
      const client = (0, _create_search_client.createSearchClient)(requestContext, framework, request);
      const snapshotResponse = await (0, _get_nodes.getNodes)(client, snapshotRequest, source, compositeSize, logQueryFields);
      return response.ok({
        body: _snapshot_api.SnapshotNodeResponseRT.encode(snapshotResponse)
      });
    } catch (err) {
      var _err$statusCode, _err$message;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : err,
        body: {
          message: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initSnapshotRoute = initSnapshotRoute;