"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initEntitiesConfigurationRoutes = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("@kbn/deeplinks-observability/constants");
var _common = require("@kbn/observability-plugin/common");
var _create_observability_es_client = require("@kbn/observability-utils-server/es/client/create_observability_es_client");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _get_infra_metrics_client = require("../../lib/helpers/get_infra_metrics_client");
var _get_data_stream_types = require("./get_data_stream_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initEntitiesConfigurationRoutes = libs => {
  const {
    framework,
    logger
  } = libs;
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/entities/{entityType}/{entityId}/summary',
    validate: {
      params: _configSchema.schema.object({
        entityType: _configSchema.schema.oneOf([_configSchema.schema.literal(_common2.BUILT_IN_ENTITY_TYPES.HOST), _configSchema.schema.literal(_common2.BUILT_IN_ENTITY_TYPES.CONTAINER)]),
        entityId: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        from: _configSchema.schema.string(),
        to: _configSchema.schema.string()
      })
    },
    options: {
      access: 'internal'
    }
  }, async (requestContext, request, response) => {
    const {
      entityId,
      entityType: entityFilterType
    } = request.params;
    const mapTypeToV2 = {
      [_common2.BUILT_IN_ENTITY_TYPES.HOST]: _common2.BUILT_IN_ENTITY_TYPES.HOST_V2,
      [_common2.BUILT_IN_ENTITY_TYPES.CONTAINER]: _common2.BUILT_IN_ENTITY_TYPES.CONTAINER_V2
    };
    const entityType = mapTypeToV2[entityFilterType];
    const {
      from,
      to
    } = request.query;
    const [coreContext, infraContext] = await Promise.all([requestContext.core, requestContext.infra]);
    const entityManagerClient = await infraContext.entityManager.getScopedClient({
      request
    });
    const infraMetricsClient = await (0, _get_infra_metrics_client.getInfraMetricsClient)({
      request,
      libs,
      context: requestContext
    });
    const obsEsClient = (0, _create_observability_es_client.createObservabilityEsClient)({
      client: coreContext.elasticsearch.client.asCurrentUser,
      logger,
      plugin: `@kbn/${_constants.METRICS_APP_ID}-plugin`
    });
    const entityCentricExperienceEnabled = await coreContext.uiSettings.client.get(_common.entityCentricExperience);
    try {
      const sourceDataStreamTypes = await (0, _get_data_stream_types.getDataStreamTypes)({
        entityCentricExperienceEnabled,
        entityId,
        entityManagerClient,
        entityType,
        entityFilterType,
        infraMetricsClient,
        obsEsClient,
        logger,
        from,
        to
      });
      return response.ok({
        body: {
          sourceDataStreams: sourceDataStreamTypes,
          entityId,
          entityType,
          entityFilterType
        }
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initEntitiesConfigurationRoutes = initEntitiesConfigurationRoutes;