"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSaveCustomDashboardRoute = initSaveCustomDashboardRoute;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _custom_dashboards_api = require("../../../common/http_api/custom_dashboards_api");
var _saved_objects = require("../../saved_objects");
var _check_custom_dashboards_enabled = require("./lib/check_custom_dashboards_enabled");
var _handle_route_errors = require("../../utils/handle_route_errors");
var _find_custom_dashboard = require("./lib/find_custom_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initSaveCustomDashboardRoute(framework) {
  const validatePayload = (0, _ioTsUtils.createRouteValidationFunction)(_custom_dashboards_api.InfraSaveCustomDashboardsRequestPayloadRT);
  const validateParams = (0, _ioTsUtils.createRouteValidationFunction)(_custom_dashboards_api.InfraGetCustomDashboardsRequestPathParamsRT);
  framework.registerRoute({
    method: 'post',
    path: '/api/infra/{assetType}/custom-dashboards',
    validate: {
      body: validatePayload,
      params: validateParams
    },
    options: {
      access: 'internal'
    }
  }, (0, _handle_route_errors.handleRouteErrors)(async (context, request, response) => {
    const {
      savedObjectsClient,
      uiSettingsClient
    } = await context.infra;
    await (0, _check_custom_dashboards_enabled.checkCustomDashboardsEnabled)(uiSettingsClient);
    const {
      dashboardSavedObjectId
    } = request.body;
    const {
      assetType
    } = request.params;
    const customDashboards = await (0, _find_custom_dashboard.findCustomDashboard)(assetType, savedObjectsClient);
    const dashboardExist = customDashboards.find(customDashboard => customDashboard.dashboardSavedObjectId === dashboardSavedObjectId);
    if (dashboardExist) {
      return response.badRequest({
        body: `Dashboard with id ${dashboardSavedObjectId} has already been linked to ${assetType}`
      });
    }
    const savedCustomDashboard = await savedObjectsClient.create(_saved_objects.INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE, {
      assetType,
      ...request.body
    });
    return response.ok({
      body: _custom_dashboards_api.InfraSaveCustomDashboardsResponseBodyRT.encode({
        id: savedCustomDashboard.id,
        ...savedCustomDashboard.attributes
      })
    });
  }));
}