"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceConfigurationSettings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _page_template = require("../../../components/page_template");
var _source_loading_page = require("../../../components/source_loading_page");
var _metrics_source = require("../../../containers/metrics_source");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _indices_configuration_panel = require("./indices_configuration_panel");
var _ml_configuration_panel = require("./ml_configuration_panel");
var _name_configuration_panel = require("./name_configuration_panel");
var _source_configuration_form_state = require("./source_configuration_form_state");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _translations = require("../../../translations");
var _features_configuration_panel = require("./features_configuration_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceConfigurationSettings = ({
  shouldAllowEdit,
  http
}) => {
  var _source$status;
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.settingsTitle
  }]);
  const [numberOfInfraRules, setNumberOfInfraRules] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    const getNumberOfInfraRules = async () => {
      if (http) {
        const {
          ruleExecutionStatus
        } = await (0, _public2.loadRuleAggregations)({
          http,
          ruleTypeIds: [_ruleDataUtils.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.METRIC_THRESHOLD_ALERT_TYPE_ID],
          consumers: [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY]
        });
        const numberOfRules = Object.values(ruleExecutionStatus).reduce((acc, value) => acc + value, 0);
        setNumberOfInfraRules(numberOfRules);
      }
    };
    getNumberOfInfraRules();
  }, [http]);
  const {
    persistSourceConfiguration: updateSourceConfiguration,
    source,
    sourceExists,
    isLoading
  } = (0, _metrics_source.useSourceContext)();
  const {
    indicesConfigurationProps,
    errors,
    resetForm,
    isFormValid,
    formState,
    formStateChanges,
    getUnsavedChanges
  } = (0, _source_configuration_form_state.useSourceConfigurationFormState)(source === null || source === void 0 ? void 0 : source.configuration);
  const infraUiSettings = (0, _public.useEditableSettings)([_common.enableInfrastructureHostsView, _common.enableInfrastructureProfilingIntegration, _common.enableInfrastructureAssetCustomDashboards, _common.enableInfrastructureContainerAssetView]);
  const resetAllUnsavedChanges = (0, _react.useCallback)(() => {
    resetForm();
    infraUiSettings.cleanUnsavedChanges();
  }, [infraUiSettings, resetForm]);
  const persistUpdates = (0, _react.useCallback)(async () => {
    await Promise.all([updateSourceConfiguration(sourceExists ? formStateChanges : formState), infraUiSettings.saveAll()]);
    resetForm();
  }, [sourceExists, resetForm, updateSourceConfiguration, formStateChanges, infraUiSettings, formState]);
  const unsavedChangesCount = Object.keys(getUnsavedChanges()).length;
  const infraUiSettingsUnsavedChangesCount = Object.keys(infraUiSettings.unsavedChanges).length;
  // Count changes from the feature section settings and general infra settings
  const unsavedFormChangesCount = infraUiSettingsUnsavedChangesCount + unsavedChangesCount;
  const isFormDirty = infraUiSettingsUnsavedChangesCount > 0 || unsavedChangesCount > 0;
  const isWriteable = shouldAllowEdit && (!Boolean(source) || (source === null || source === void 0 ? void 0 : source.origin) !== 'internal');
  const {
    metricIndicesExist,
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  const {
    hasInfraMLCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  if (isLoading && !source) {
    return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    pageHeader: {
      pageTitle: _translations.settingsTitle
    },
    "data-test-subj": "sourceConfigurationContent",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public.Prompt, {
    prompt: isFormDirty ? _i18n.i18n.translate('xpack.infra.sourceConfiguration.unsavedFormPrompt', {
      defaultMessage: 'Are you sure you want to leave? Changes will be lost'
    }) : undefined
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_name_configuration_panel.NameConfigurationPanel, {
    isLoading: isLoading,
    nameFieldProps: indicesConfigurationProps.name,
    readOnly: !isWriteable
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_indices_configuration_panel.IndicesConfigurationPanel, {
    isLoading: isLoading,
    metricAliasFieldProps: indicesConfigurationProps.metricAlias,
    readOnly: !isWriteable,
    metricIndicesExist: metricIndicesExist,
    remoteClustersExist: remoteClustersExist,
    isMetricAliasChanged: Boolean(getUnsavedChanges().metricAlias),
    numberOfInfraRules: numberOfInfraRules
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasInfraMLCapabilities && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_ml_configuration_panel.MLConfigurationPanel, {
    isLoading: isLoading,
    readOnly: !isWriteable,
    anomalyThresholdFieldProps: indicesConfigurationProps.anomalyThreshold
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_features_configuration_panel.FeaturesConfigurationPanel, (0, _extends2.default)({
    readOnly: !isWriteable
  }, infraUiSettings))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("ul", null, errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement("li", {
    key: errorIndex
  }, error)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isFormDirty && /*#__PURE__*/_react.default.createElement(_public.BottomBarActions, {
    areChangesInvalid: !isFormValid,
    isLoading: infraUiSettings.isSaving,
    onDiscardChanges: resetAllUnsavedChanges,
    onSave: persistUpdates,
    saveLabel: _i18n.i18n.translate('xpack.infra.sourceConfiguration.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: unsavedFormChangesCount,
    appTestSubj: "infra"
  }))));
};
exports.SourceConfigurationSettings = SourceConfigurationSettings;