"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _asset_detail_page = require("./asset_detail_page");
var _metric_detail_page = require("./metric_detail_page");
var _use_metrics_time = require("./hooks/use_metrics_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeDetail = () => {
  const {
    params: {
      type: nodeType
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const isContainerAssetViewEnabled = (0, _public.useUiSetting)(_common.enableInfrastructureContainerAssetView);
  const showContainerAssetDetailPage = nodeType === 'container' && isContainerAssetViewEnabled;
  return nodeType === 'host' || showContainerAssetDetailPage ? /*#__PURE__*/_react.default.createElement(_asset_detail_page.AssetDetailPage, null) : /*#__PURE__*/_react.default.createElement(_use_metrics_time.MetricsTimeProvider, null, /*#__PURE__*/_react.default.createElement(_metric_detail_page.MetricDetailPage, null));
};
exports.NodeDetail = NodeDetail;