"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageError = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_document_title = require("../../../../hooks/use_document_title");
var _invalid_node = require("./invalid_node");
var _error = require("../../../error");
var _translations = require("../../../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageError = ({
  error,
  name
}) => {
  var _error$body;
  (0, _use_document_title.useDocumentTitle)([{
    text: _translations.errorTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404 ? /*#__PURE__*/_react.default.createElement(_invalid_node.InvalidNodeError, {
    nodeName: name
  }) : /*#__PURE__*/_react.default.createElement(_error.ErrorPageBody, {
    message: error.message
  }));
};
exports.PageError = PageError;