"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.seriesHasLessThen2DataPoints = exports.getMaxMinTimestamp = exports.getFormatter = exports.getChartType = exports.getChartName = exports.getChartColor = void 0;
var _color = _interopRequireDefault(require("color"));
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _formatters = require("../../../../../common/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a formatter
 */
const getFormatter = (formatter = 'number', template = '{{value}}') => val => val != null ? (0, _formatters.createFormatter)(formatter, template)(val) : '';

/**
 * Does a series have more then two points?
 */
exports.getFormatter = getFormatter;
const seriesHasLessThen2DataPoints = series => {
  return series.data.length < 2;
};

/**
 * Returns the minimum and maximum timestamp for a metric
 */
exports.seriesHasLessThen2DataPoints = seriesHasLessThen2DataPoints;
const getMaxMinTimestamp = metric => {
  if (metric.series.some(seriesHasLessThen2DataPoints)) {
    return [0, 0];
  }
  const values = metric.series.reduce((acc, item) => {
    const firstRow = (0, _lodash.first)(item.data);
    const lastRow = (0, _lodash.last)(item.data);
    return acc.concat([firstRow && firstRow.timestamp || 0, lastRow && lastRow.timestamp || 0]);
  }, []);
  return [(0, _lodash.min)(values), (0, _lodash.max)(values)];
};

/**
 * Returns the chart name from the visConfig based on the series id, otherwise it
 * just returns the seriesId
 */
exports.getMaxMinTimestamp = getMaxMinTimestamp;
const getChartName = (seriesOverrides, seriesId, label) => {
  if (!seriesOverrides) {
    return label;
  }
  return (0, _lodash.get)(seriesOverrides, [seriesId, 'name'], label);
};

/**
 * Returns the chart color from the visConfig based on the series id, otherwise it
 * just returns null if the color doesn't exists in the overrides.
 */
exports.getChartName = getChartName;
const getChartColor = (seriesOverrides, seriesId) => {
  const rawColor = seriesOverrides ? (0, _lodash.get)(seriesOverrides, [seriesId, 'color']) : null;
  if (!rawColor) {
    return null;
  }
  const color = new _color.default(rawColor);
  return color.hex().toString();
};

/**
 * Gets the chart type based on the section and seriesId
 */
exports.getChartColor = getChartColor;
const getChartType = (seriesOverrides, type, seriesId) => {
  if (!seriesOverrides || !type) {
    return 'line';
  }
  const overrideValue = (0, _lodash.get)(seriesOverrides, [seriesId, 'type']);
  if (_common.InventoryVisTypeRT.is(overrideValue)) {
    return overrideValue;
  }
  if (_common.InventoryVisTypeRT.is(type)) {
    return type;
  }
  return 'line';
};
exports.getChartType = getChartType;