"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInfraWaffleMapGradientLegend = isInfraWaffleMapGradientLegend;
exports.isInfraWaffleMapStepLegend = isInfraWaffleMapStepLegend;
exports.isWaffleMapGroupWithGroups = isWaffleMapGroupWithGroups;
exports.isWaffleMapGroupWithNodes = isWaffleMapGroupWithNodes;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isInfraWaffleMapStepLegend(subject) {
  return subject.type && subject.type === 'step';
}
function isInfraWaffleMapGradientLegend(subject) {
  return subject.type && subject.type === 'gradient';
}
function isWaffleMapGroupWithNodes(subject) {
  return subject && subject.nodes != null && Array.isArray(subject.nodes);
}
function isWaffleMapGroupWithGroups(subject) {
  return subject && subject.groups != null && Array.isArray(subject.groups);
}